#include "General.h"

HashTemplateClass<StringClass, ChatCommand *> Commands::CommandTable;

void Commands::Load()
{
	REGISTER_COMMAND(Help, FLAG_BOTH, "Help", Help_Registrant);
	REGISTER_COMMAND(Auth, FLAG_IRC, "Auth", Auth_Registrant);
	REGISTER_COMMAND(GameInfo, FLAG_IRC, "GameInfo", GameInfo_Registrant);
	REGISTER_COMMAND(ListPlayers, FLAG_IRC, "ListPlayers", ListPlayers_Registrant);
	REGISTER_COMMAND(Buildings, FLAG_IRC, "Buildings", Buildings_Registrant);
	REGISTER_COMMAND(Rotation, FLAG_BOTH, "Rotation", Rotation_Registrant);
	REGISTER_COMMAND(NextMap, FLAG_BOTH, "NextMap", NextMap_Registrant);
	REGISTER_COMMAND(Ping, FLAG_BOTH, "Ping", Ping_Registrant);
	REGISTER_COMMAND(Rules, FLAG_BOTH, "Rules", Rules_Registrant);
	REGISTER_COMMAND(VehicleLimit, FLAG_BOTH, "VehicleLimit", VehicleLimit_Registrant);
	REGISTER_COMMAND(MineLimit, FLAG_BOTH, "MineLimit", MineLimit_Registrant);
	REGISTER_COMMAND(Version, FLAG_BOTH, "Version", Version_Registrant);
	REGISTER_COMMAND(ShowMods, FLAG_BOTH, "ShowMods", ShowMods_Registrant);
	REGISTER_COMMAND(FDS, FLAG_BOTH, "FDS", FDS_Registrant);
	REGISTER_COMMAND(Kill, FLAG_BOTH, "Kill", Kill_Registrant);
	REGISTER_COMMAND(AdminMessage, FLAG_IRC, "AdminMessage", AdminMessage_Registrant);
	REGISTER_COMMAND(Message, FLAG_IRC, "Message", Message_Registrant);
	REGISTER_COMMAND(Mute, FLAG_BOTH, "Mute", Mute_Registrant);
	REGISTER_COMMAND(TeamChange, FLAG_BOTH, "TeamChange", TeamChange_Registrant);
	REGISTER_COMMAND(PlayerScripts, FLAG_IRC, "PlayerScripts", PlayerScripts_Registrant);
	REGISTER_COMMAND(ScriptsCommand, FLAG_BOTH, "ScriptsCommand", ScriptsCommand_Registrant);
	REGISTER_COMMAND(ScriptsDownload, FLAG_GAME, "ScriptsDownload", ScriptsDownload_Registrant);
	REGISTER_COMMAND(UpTime, FLAG_BOTH, "UpTime", UpTime_Registrant);
	REGISTER_COMMAND(MapTime, FLAG_BOTH, "MapTime", MapTime_Registrant);
	REGISTER_COMMAND(Disarm, FLAG_BOTH, "Disarm", Disarm_Registrant);
	REGISTER_COMMAND(SetNextMap, FLAG_BOTH, "SetNextMap", SetNextMap_Registrant);
	REGISTER_COMMAND(PageCommand, FLAG_IRC, "PageCommand", PageCommand_Registrant);
	REGISTER_COMMAND(PlayerAdminMessage, FLAG_IRC, "PlayerAdminMessage", PlayerAdminMessage_Registrant);
	REGISTER_COMMAND(Bandwidth, FLAG_IRC, "Bandwidth", Bandwidth_Registrant);
	REGISTER_COMMAND(ModeratorList, FLAG_IRC, "ModeratorList", ModeratorList_Registrant);
	REGISTER_COMMAND(LogSearch, FLAG_IRC, "LogSearch", LogSearch_Registrant);
}

void Commands::Unload()
{
}

DWORD WINAPI Commands::Game_Chat(LPVOID params)
{
	Sleep(500); 	 // 0.5 seconds
	GameChat_t* Data = (GameChat_t*) params;

	Tokenizer Tokens(Data->Message);
	if (Commands::CommandTable.Exists(Tokens[1]))
	{
		ChatCommand* c;
		c = Commands::CommandTable.Get(Tokens[1], 0);
		c->Activate(Data->PlayerID, Data->Type, Tokens);
	}

	delete Data;
	return 0;
}

void ChatCommand::Startup(const char *Name, int Use)
{
	StringClass Triggers, Trigger, HelpInfo, Access;

	Triggers = Settings::Load_String(ABDIR "Commands.ini", Name, "Trigger");
	HelpInfo = Settings::Load_String(ABDIR "Commands.ini", Name, "HelpInfo");
	Access = Settings::Load_String(ABDIR "Commands.ini", Name, "Access");
	Hide = Settings::Load_Bool(ABDIR "Commands.ini", Name, "Hide");

	if (Access != ".")
	{
		ChatCommand::Access = Access;
	}

	ChatCommand::HelpInfo = HelpInfo;
	ChatCommand::Name = Name;
	ChatCommand::Use = Use;

	Tokenizer Tokens(Triggers);

	for (int i = 1; i < Tokens.Size()+1; i++)
	{
		Trigger = Tokens[i];
		Commands::CommandTable.Insert(Trigger, this);
	}
}

void ChatCommand::Activate(int ID, int Type, Tokenizer Msg)
{
	Functions::Page(ID, "You cannot use the %s command in-game.", ChatCommand::Name);
}
void ChatCommand::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	IRC::Send("PRIVMSG %s :You can't use the %s command from IRC.\n", Channel, ChatCommand::Name);
}

void Auth::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :Syntax !auth <PlayerName>\n", Channel);
		return;
	}

	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		GameObject* o = Functions::Get_Part_Name_Fixed(Msg[2]);
		Player_t* Data = Player::Get(Get_Player_ID(o));

		if (Data)
		{
			if (Settings::ModsGameNick.Exists(Data->Nick))
			{
				if (Data->Access != "p")
				{
					IRC::Send("PRIVMSG %s :Player has already authenticated.\n", Channel);
				}
				else
				{
					IRC::Send("PRIVMSG %s :Player has been authenticated.\n", Channel);
					Data->Access = Settings::ModsGameNick.Get(Data->Nick,0)->Access;
					Functions::Announce_Auth(Data);
				}
			}
			else
			{
				IRC::Send("PRIVMSG %s :Player not found in moderator list.\n", Channel);
			}
		}
		else
		{
			IRC::Send("PRIVMSG %s :Player data not found.\n", Channel);
		}
	}
}

void GameInfo::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	char TimeStr[128];
	if (Settings::IsMarathon)
	{
		Functions::Format_Time((time_t)The_Game()->Get_Game_Duration_S(), "%H:%M:%S", TimeStr, 256);
	}
	else
	{
		Functions::Format_Time((time_t)The_Game()->Get_Time_Remaining_Seconds(), "%H:%M:%S", TimeStr, 256);
	}

	char NodStr[256];
	char GDIStr[256];

	sprintf(NodStr, "%d/%d players", Get_Team_Player_Count(NOD), The_Game()->Get_Max_Players());
	sprintf(GDIStr, "%d/%d players", Get_Team_Player_Count(GDI), The_Game()->Get_Max_Players());

	IRC::Send("PRIVMSG %s :%sMap: %s%s %sGDI: %s %.0f points%s %sNod: %s %.0f points%s %sTime %s: %s FPS: %d%s\n", 
		Channel, LGREY, Get_Map(Get_Current_Map_Index()), NM, YELLOW, GDIStr, Get_Team_Score(GDI), NM,
		RED, NodStr, Get_Team_Score(NOD), NM, LGREY, Settings::IsMarathon ? "expired" : "left", TimeStr, -1, NM); 
}

void ListPlayers::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (The_Game()->Get_Current_Players() == 0)
	{
		IRC::Send("PRIVMSG %s :No players.\n", Channel);
		return;
	}

	int x = 0; // x contains the number of names displayed, gets reset to 0 if 4 or more
	StringClass Output; // The text to output per line of 4 players

	for (int i = 1; i >= 0; i--) // i = Team to display for
	{
		for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
		{
			cPlayer *p = (cPlayer *)PlayerIter->Data();
			if (Get_Team(p->PlayerId) == i && p->IsActive)
			{
				Player_t *Data = Player::Get(p->PlayerId);

				if (Data)
				{
					if (Data->Access != "p")
					{
						Output += Data->Access;
					}
				}

				Output += Data->Nick;
				Output += "\t";
				x++;
			}
			if (x >= 4)
			{
				IRC::Send("PRIVMSG %s :%s%s%s:%s %s%s\n", Channel, i ? YELLOW : RED, BOLD, i ? "GDI" : "Nod", NM, RED, Output, NM);
				Output = "";
				x = 0;
			}
		}
		if (x > 0)
		{
			IRC::Send("PRIVMSG %s :%s%s%s:%s %s%s\n", Channel, i ? YELLOW : RED, BOLD, i ? "GDI" : "Nod", NM, i ? YELLOW : RED, Output, NM);
			Output = "";
			x = 0;
		}
		else if (Get_Team_Player_Count(i) == 0)
		{
			IRC::Send("PRIVMSG %s :%s%s%s: %s%sNo players.%s\n", Channel, i ? YELLOW : RED, BOLD, i ? "GDI" : "Nod", NM, i ? YELLOW : RED, NM);
		}
	}
}

void Buildings::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	DLOG;
	StringClass Colour, GDI_, Nod_, Temp;

	SLNode<BuildingGameObj> *x = GameObjManager::BuildingGameObjList.Head();
	while (x)
	{
		GameObject *o = (GameObject *)x->Data();

		if(!o)
		{
			continue;
		}

		const char* Name = Functions::Get_Translated_Name(o);

		if(!Name)
		{
			continue;
		}

		if(Get_Object_Type(o) == NOD)
		{
			Colour = RED;
			if (Commands->Get_Health(o) == 0.0f)
			{
				Colour = LGREY;
			}
		}
		else if(Get_Object_Type(o) == GDI)
		{
			Colour = YELLOW;

			if (Commands->Get_Health(o) == 0.0f)
			{
				Colour = LGREY;
			}
		}

		Temp = StringClass::getFormattedString("%s%s (%.0f/%.0f)%s  ", Colour, Name, Commands->Get_Health(o), Commands->Get_Max_Health(o), NM);

		if(Get_Object_Type(o) == NOD)
		{
			Nod_ += Temp;
		}
		else
		{
			GDI_ += Temp;
		}
		x = x->Next();
	}

	if(GDI_.Is_Empty() && Nod_.Is_Empty())
	{
		IRC::SendC(Channel, "No buildings found in-game.");
	}
	else
	{
		IRC::SendC(Channel, "%s", GDI_);
		IRC::SendC(Channel, "%s", Nod_);
	}
}

void Rotation::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	StringClass Rotation;

	for (int i = 0;; i++)
	{
		const char *x = Get_Map(i);
		if( x != NULL)
		{
			if (Rotation.Get_Length() + strlen(x)+2 > 128)
			{
				IRC::SendC(Channel, "%s", Rotation.Peek_Buffer()+1);
				Rotation = "";
			}
			if (Get_Current_Map_Index() == i)
			{
				Rotation += " [";
				Rotation += x;
				Rotation += "]";
			}
			else
			{
				Rotation += " ";
				Rotation += x;
			}
		}
		else
		{
			break;
		}
	}
	if(!Rotation.Is_Empty())
	{
		IRC::SendC(Channel, "%s%s", BOLD, Rotation.Peek_Buffer()+1);
	}
}

void Rotation::Activate(int ID, int Type, Tokenizer Msg)
{
	StringClass Rotation;

	for (int i = 0;; i++)
	{
		const char *x = Get_Map(i);
		if( x != NULL)
		{
			if (Rotation.Get_Length() + strlen(x)+2 > 128)
			{
				Functions::Page(ID, "%s", Rotation.Peek_Buffer()+1);
				Rotation = "";
			}
			if (Get_Current_Map_Index() == i)
			{
				Rotation += " [";
				Rotation += x;
				Rotation += "]";
			}
			else
			{
				Rotation += " ";
				Rotation += x;
			}
		}
		else
		{
			break;
		}
	}
	if(!Rotation.Is_Empty())
	{
		Functions::Page(ID, "%s", Rotation.Peek_Buffer()+1);
	}
}

void NextMap::Activate(int ID, int Type, Tokenizer Msg)
{
	int NextID = Get_Current_Map_Index() + 1;
	const char *x = Get_Map(NextID);

	if( x == NULL) // Check if the next map exists in the rotation
	{			   // If not the next map is the first map in the rotation
		NextID = 0;
	}

	StringClass MapName = Get_Map(NextID);
	Functions::Page(ID, "The next map will be: C&C_%s.mix", MapName);
}
 
void NextMap::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	int NextID = Get_Current_Map_Index() + 1;

	const char *x = Get_Map(NextID);
	if( x == NULL)
	{
		NextID = 0;
	}	
	StringClass MapName = Get_Map(NextID);

	IRC::SendC(Channel, "The next map will be: C&C_%s.mix", MapName);
}

void Ping::Activate(int ID, int Type, Tokenizer Msg)
{
	if (Msg.Size() > 1)
	{
		int Count = Functions::Get_Part_Names_Fixed(Msg[2]);
		if (Count < 1)
		{
			Functions::Page(ID,"Player not found.");
		}
		else if (Count > 1)
		{
			Functions::Page(ID, "Multiple players found.");
		}
		else
		{
			int OtherID = Get_Player_ID(Functions::Get_Part_Name_Fixed(Msg[2]));
			Player_t* p = Player::Get(OtherID);

			Functions::Page(ID,"%s's ping is %d.", p->Nick, Get_Ping(p->PlayerId));
		}
	}
	else
	{
		Functions::Page(ID,"Your ping is %d.", Get_Ping(ID));
	}
}

void Ping::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :Usage: !ping <name>.\n", Channel);
		return;
	}

	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		int ID = Get_Player_ID(Functions::Get_Part_Name_Fixed(Msg[2]));
		Player_t* p = Player::Get(ID);

		IRC::Send("PRIVMSG %s :%s's ping is %d.\n", Channel, p->Nick, Get_Ping(p->PlayerId));
	}
}

void Rules::Activate(int ID, int Type, Tokenizer Msg)
{
	Functions::Host_Msg("%s", Settings::Rules);
	Functions::Host_Msg("Map rules: %s", Settings::MapRules);
}

void Rules::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	Functions::Host_Msg("%s", Settings::Rules);
	Functions::Host_Msg("Map rules: %s", Settings::MapRules);
}

void VehicleLimit::Activate(int ID, int Type, Tokenizer Msg)
{
	Functions::Page(ID, "The vehicle limit is: %d.", Get_Vehicle_Limit());
}

void VehicleLimit::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	IRC::SendC(Channel, "The vehicle limit is: %d.", Get_Vehicle_Limit());
}

void MineLimit::Activate(int ID, int Type, Tokenizer Msg)
{
	Functions::Page(ID, "The mine limit on this map is - Remote C4: %d | Proxy C4: %d.", Get_Mine_Limit(), Get_Mine_Limit());
}

void MineLimit::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	IRC::SendC(Channel, "The mine limit on this map is - Remote C4: %d | Proxy C4: %d.", Get_Mine_Limit(), Get_Mine_Limit());
}

void Version::Activate(int ID, int Type, Tokenizer Msg)
{
	Functions::Page(ID, "Running AzazelBot written by Iran, based on OnOeS written by Hex, jnz and pvtschlag.");
}

void Version::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	IRC::SendC(Channel, "Running AzazelBot written by Iran, based on OnOeS written by Hex, jnz and pvtschlag.");
}

void ShowMods::Activate(int ID, int Type, Tokenizer Msg)
{
	StringClass ModList = "Moderator(s) in-game:";
	bool Found = false;

	for(int i = 1; i < (int)The_Game()->Get_Max_Players() + 1; i++)
	{
		Player_t *x = Player::Get(i);

		if (!x)
		{
			continue;
		}
		if(x->Access != "p")
		{
			Found = true;

			if(ModList.Get_Length() > 80)
			{
				Functions::Host_Msg(ModList);
				ModList = " ";
			}

			ModList += StringClass().getFormattedString(" %s%s", x->Access, x->Nick); 
		}
	}

	if (Found)
	{
		Functions::Host_Msg(ModList);
	}
	else
	{
		Functions::Host_Msg("No moderators in-game.");
	}
}

void ShowMods::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	StringClass ModList = "Moderator(s) in-game:";
	bool Found = false;

	for(int i = 1; i < The_Game()->Get_Max_Players() + 1; i++)
	{
		Player_t *x = Player::Get(i);
		if(!x->PlayerId)
		{
			continue;
		}
		if(x->Access != "p")
		{
			Found = true;

			if(ModList.Get_Length() > 80)
			{
				IRC::Send("PRIVMSG %s :%s\n", Channel, ModList);
				ModList = " ";
			}

			ModList += StringClass().getFormattedString(" %s%s", x->Access, x->Nick); 
		}
	}

	if (Found)
	{
		IRC::Send("PRIVMSG %s :%s\n", Channel, ModList);
	}
	else
	{
		IRC::Send("PRIVMSG %s :No moderators in-game.\n", Channel);
	}
}

void FDS::Activate(int ID, int Type, Tokenizer Msg)
{
	if(Msg.Size() < 2)
	{
		Functions::Page(ID, "Usage: !fds <command>");
		return;
	}	
	StringClass Command;

	for (int i = 2; i < Msg.Size()+1; i++)
	{
		Command += Msg[i];
		
		if (i != Msg.Size())
		{
			Command += " ";
		}
	}
	Functions::Console(Command);
	Functions::Page(ID, "FDS command sent.");
}

void FDS::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if(Msg.Size() < 2)
	{
		IRC::Send("PRIVMSG %s :Usage: !fds <command>\n", Channel);
		return;
	}	
	StringClass Command;

	for (int i = 2; i < Msg.Size()+1; i++)
	{
		Command += Msg[i];
		
		if (i != Msg.Size())
		{
			Command += " ";
		}
	}
	Functions::Console(Command);
	IRC::Send("PRIVMSG %s :FDS command sent.\n", Channel);
}

void Kill::Activate(int ID, int Type, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		Functions::Page(ID, "Usage: !kill <name>.");
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		Functions::Page(ID, "Player not found.");
	}
	else if (Count > 1)
	{
		Functions::Page(ID, "Multiple players found.");
	}
	else
	{
		GameObject* Target = Functions::Get_Part_Name_Fixed(Msg[2]);
		int TargetID = Get_Player_ID(Target);
		
		if (Get_Vehicle(Target))
		{
			Soldier_Transition_Vehicle(Target);
		}
		// Sleep(300); // 0.3 seconds, needed as apply damage doesn't work without a wait, use Destroy_Object() instead
		// Commands->Apply_Damage(Target, 8000.0f, "Death", 0);
		Commands->Destroy_Object(Target);
		Functions::Page(TargetID, "%S has killed you.", Find_Player(ID)->PlayerName);
	}
}

void Kill::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :Usage: !kill <name>.\n", Channel);
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		GameObject* Target = Functions::Get_Part_Name_Fixed(Msg[2]);
		int TargetID = Get_Player_ID(Target);
		
		if (Get_Vehicle(Target))
		{
			Soldier_Transition_Vehicle(Target);
		}
		// Sleep(300); // 0.3 seconds, needed as apply damage doesn't work without a wait, use Destroy_Object() instead
		// Commands->Apply_Damage(Target, 8000.0f, "Death", 0);
		Commands->Destroy_Object(Target);
		Functions::Page(TargetID, "%s@IRC has killed you.", Nick);
	}
}

void AdminMessage::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() < 2)
	{
		IRC::Send("PRIVMSG %s :Usage: !amsg <message>\n", Channel);
		return;
	}
	StringClass Command;

	for (int i = 2; i < Msg.Size()+1; i++)
	{
		Command += Msg[i];
		
		if (i != Msg.Size())
		{
			Command += " ";
		}
	}

	Functions::Console("AMSG (%s@IRC): %s", Nick, Command);
	IRC::SendC(CHAN_PUBLIC, "%s[AMSG]%s %s(%s@IRC): %s%s\n", ORANGE, NM, GREY, Nick, Command, NM);
}

void Message::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() < 2)
	{
		IRC::Send("PRIVMSG %s :Usage: !msg <message>\n", Channel);
		return;
	}
	StringClass Command;

	for (int i = 2; i < Msg.Size()+1; i++)
	{
		Command += Msg[i];
		
		if (i != Msg.Size())
		{
			Command += " ";
		}
	}

	Functions::Console("MSG (%s@IRC): %s", Nick, Command);
}

void Mute::Activate(int ID, int Type, Tokenizer Msg)
{
	
}

void Mute::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :Usage: !mute <name>.\n", Channel);
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		StringClass Text;

		Player_t* Data = Player::Get(Get_Player_ID(Functions::Get_Part_Name_Fixed(Msg[2])));

		if (!Data)
		{
			return;
		}
	
		if (Data->Muted)
		{
			if (Functions::Get_Status(Nick) < 4)
			{
				Data->Muted = false;
				Functions::Page(Data->PlayerId,"%s@IRC has unmuted you.", Nick);
				IRC::Send("PRIVMSG %s :%s has been unmuted.\n", Channel, Data->Nick);

				Text = StringClass().getFormattedString("%s removed temp mute for: %s", Nick, Data->Nick);
				DB::Query(0, "INSERT INTO Log(Type, Action, time) VALUES('Unmute', '%q', '%d');", Text, time(0));
			}
			else
			{
				Data->Muted = false;
				Functions::Page(Data->PlayerId,"%s@IRC has unmuted you.", Nick);
				IRC::Send("PRIVMSG %s :%s has been unmuted.\n", Channel, Data->Nick);

				DB::Query(0, "UPDATE PlayerSettings SET Muted = 'no' WHERE Nick = '%q';", Data->Nick);
				Text = StringClass().getFormattedString("%s removed mute for: %s", Nick, Data->Nick);
				DB::Query(0, "INSERT INTO Log(Type, Action, time) VALUES('Unmute', '%q', '%d');", Text, time(0));
			}
		}
		else
		{
			if (Functions::Get_Status(Nick) < 4)
			{
				Data->Muted = true;

				Functions::Page(Data->PlayerId, "%s@IRC has temp muted you, you can no longer chat or use commands.", Nick);
				IRC::Send("PRIVMSG %s :%s has been temp muted\n", Channel, Data->Nick);

				Text = StringClass().getFormattedString("%s added temp mute for: %s", Nick, Data->Nick);
				DB::Query(0, "INSERT INTO Log(Type, Action, time) VALUES('Temp Mute', '%q', '%d');", Text, time(0));
			}
			else
			{
				Data->Muted = true;

				Functions::Page(Data->PlayerId, "%s@IRC has muted you, you can no longer chat or use commands.", Nick);
				IRC::Send("PRIVMSG %s :%s has been muted.\n", Channel, Data->Nick);

				DB::Query(0, "UPDATE PlayerSettings SET Muted = 'yes' WHERE Nick = '%q';", Data->Nick);
				Text = StringClass().getFormattedString("%s added mute for: %s", Nick, Data->Nick);
				DB::Query(0, "INSERT INTO Log(Type, Action, time) VALUES('Mute', '%q', '%d');", Text, time(0));
			}
		}
	}
}

void TeamChange::Activate(int ID, int Type, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		Functions::Page(ID, "Usage: !forcetc <name>.");
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		Functions::Page(ID, "Player not found.");
	}
	else if (Count > 1)
	{
		Functions::Page(ID, "Multiple players found.");
	}
	else
	{
		GameObject* Target = Functions::Get_Part_Name_Fixed(Msg[2]);
		int TargetID = Get_Player_ID(Target);
		WideStringClass TargetName = Find_Player(TargetID)->PlayerName;

		Functions::Host_Msg("%S has been swapped to team %s by %S,", TargetName, Get_Team(TargetID) ? "Nod" : "GDI", Find_Player(ID)->PlayerName); 
		Functions::Console("team2 %d %d", TargetID, Get_Team(TargetID) ? NOD : GDI);

		Find_Player(TargetID)->Deaths = (int)Find_Player(TargetID)->Deaths - 1; // Decrement death count as TEAM2 kills the player
	}
}

void TeamChange::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	DLOG;
//	DLOG_(derp3, "derp textt");

	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :Usage: !forcetc <name>.\n", Channel);
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		GameObject* Target = Functions::Get_Part_Name_Fixed(Msg[2]);
		int TargetID = Get_Player_ID(Target);
		WideStringClass TargetName = Find_Player(TargetID)->PlayerName;

		Functions::Host_Msg("%S has been swapped to team %s by %s@IRC.", TargetName, Get_Team(TargetID) ? "Nod" : "GDI", Nick); 
		Functions::Console("team2 %d %d", TargetID, Get_Team(TargetID) ? NOD : GDI);

		Find_Player(TargetID)->Deaths = (int)Find_Player(TargetID)->Deaths - 1; // Decrement death count as TEAM2 kills the player
	}
}

void PlayerScripts::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	StringClass Scripts = "Scripts:";
	bool Found = 0;

	for(int i = 1; i < (int)The_Game()->Get_Max_Players() + 1; i++)
	{
		Player_t *x = Player::Get(i);
		if(!x->PlayerId)
		{
			continue;
		}
		
		Found = 1;
		if(Scripts.Get_Length() > 60)
		{
			IRC::Send("PRIVMSG %s :%s\n", Channel, Scripts);
			Scripts += "Scripts:";
		}
		Scripts += StringClass().getFormattedString(" %s(%.2f)", x->Nick, Get_Client_Version(x->PlayerId));
	}

	if(Found)
	{
		IRC::Send("PRIVMSG %s :%s\n", Channel, Scripts);
	}
	else
	{
		IRC::Send("PRIVMSG %s :No players.\n", Channel);
	}
}

void ScriptsCommand::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :usage !scripts <name>.\n", Channel);
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		int TargetID = Get_Player_ID(Functions::Get_Part_Name_Fixed(Msg[2]));
		WideStringClass TargetName = Find_Player(TargetID)->PlayerName;
		IRC::Send("PRIVMSG %s :Player %S is running version %.2f of scripts.dll.\n", Channel, TargetName, Get_Client_Version(TargetID));
	}
}

void ScriptsCommand::Activate(int ID, int Type, Tokenizer Msg)
{
	if (Msg.Size() < 2)
	{
		float Version = Get_Client_Version(ID);
		Functions::Page(ID, "Your running version %.2f of scripts.dll.", Version);

		if (Version < 4.0f)
		{
			Functions::Page(ID, "Type !!scripts (TWO !) for the latest scripts.dll download link.");
		}
		return;
	}	
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		Functions::Page(ID, "Player not found.");
	}
	else if (Count > 1)
	{
		Functions::Page(ID, "Multiple players found.");
	}
	else
	{
		int TargetID = Get_Player_ID(Functions::Get_Part_Name_Fixed(Msg[2]));
		WideStringClass TargetName = Find_Player(TargetID)->PlayerName;
		Functions::Page(ID, "Player %S is running version %.2f of scripts.dll.\n", TargetName, Get_Client_Version(TargetID));
	}
}

void ScriptsDownload::Activate(int ID, int Type, Tokenizer Msg)
{
	Functions::Console("PAMSG %d You can download the latest scripts.dll CLIENT from: http://www.tiberiantechnologies.org/downloads", ID);
}

void UpTime::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	time_t t_ = time(0)-Settings::StartTime;
	int Seconds = (int)(t_ % 60);
	int Minutes = (int)((t_ / 60) % 60);
	int Hours = (int)((t_ /(60 * 60)) % 24);
	int Days = (int)(t_ / (60 * 60 * 24));
	IRC::Send("PRIVMSG %s :I've been running for: %d day%s, %d hour%s, %d minute%s and %d second%s.\n", Channel, Days, Days == 1 ? "" : "s", Hours, Hours == 1 ? "" : "s", Minutes, Minutes == 1 ? "" : "s", Seconds, Seconds == 1 ? "" : "s");
}

void UpTime::Activate(int ID, int Type, Tokenizer Msg)
{
	time_t t_ = time(0)-Settings::StartTime;
	int Seconds = (int)(t_ % 60);
	int Minutes = (int)((t_ / 60) % 60);
	int Hours = (int)((t_ /(60 * 60)) % 24);
	int Days = (int)(t_ / (60 * 60 * 24));
	Functions::Page(ID, "I've been running for: %d day%s, %d hour%s, %d minute%s and %d second%s.", Days, Days == 1 ? "" : "s", Hours, Hours == 1 ? "" : "s", Minutes, Minutes == 1 ? "" : "s", Seconds, Seconds == 1 ? "" : "s");
}

void MapTime::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	char TimeStr[256];
	Functions::Format_Time((time_t)The_Game()->Get_Game_Duration_S(), "%H:%M:%S", TimeStr, 256);
	IRC::Send("PRIVMSG %s :Current map time: %s.\n", Channel, TimeStr);
}

void MapTime::Activate(int ID, int Type, Tokenizer Msg)
{
	char TimeStr[256];
	Functions::Format_Time((time_t)The_Game()->Get_Game_Duration_S(), "%H:%M:%S", TimeStr, 256);
	Functions::Page(ID, "Current map time: %s.", TimeStr);
}

void Disarm::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :usage !disarm <name>.\n", Channel);
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		int TargetID = Get_Player_ID(Functions::Get_Part_Name_Fixed(Msg[2]));
		Functions::Disarm_Player(TargetID);
		Functions::Host_Msg("All C4 and beacons laid by %S have been disarmed.", Find_Player(TargetID)->PlayerName);
	}
}

void Disarm::Activate(int ID, int Type, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		Functions::Page(ID, "Usage !disarm <name>.");
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		Functions::Page(ID, "Player not found.");
	}
	else if (Count > 1)
	{
		Functions::Page(ID, "Multiple players found.");
	}
	else
	{
		int TargetID = Get_Player_ID(Functions::Get_Part_Name_Fixed(Msg[2]));
		Functions::Disarm_Player(TargetID);
		Functions::Host_Msg("All C4 and beacons laid by %S have been disarmed.", Find_Player(TargetID)->PlayerName);
	}
}

void SetNextMap::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :usage !setnextmap <name>.\n", Channel);
		return;
	}
	int NextID = Get_Current_Map_Index() + 1;

	const char *temp = Get_Map(NextID);
	if( temp == NULL)
	{
		NextID = 0;
	}
		
	for(int i = 0;; i++)
	{
		const char *x = Get_Map(i);
		if( x != NULL)
		{
			if (stristr(x, Msg[2]))
			{
				if (Set_Map(x, NextID))
				{
					IRC::Send("PRIVMSG %s :The next map was set to %s.\n", Channel, x);
				}
				else
				{
					IRC::Send("PRIVMSG %s :Unknown error trying to set map to %s.\n", Channel, x);
				}
				return;
			}
		}
		else
		{
			break;
		}
	}
	IRC::SendC(Channel, "Map not found.");
}

void SetNextMap::Activate(int ID, int Type, Tokenizer Msg)
{
}

void PageCommand::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() < 3)
	{
		IRC::Send("PRIVMSG %s :Usage: !page <name> <message>.\n", Channel);
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		GameObject* Target = Functions::Get_Part_Name_Fixed(Msg[2]);
		int TargetID = Get_Player_ID(Target);		
		StringClass Text;

		for (int i = 3; i < Msg.Size()+1; i++)
		{
			Text += Msg[i];	
			if (i != Msg.Size())
			{
				Text += " ";
			}
		}
		Functions::Page(TargetID, "PM from %s@IRC: %s", Nick, Text);
		IRC::SendC(CHAN_BOTH, "%sPage sent to %S -> (%s@IRC): %s%s", LGREEN, Find_Player(TargetID)->PlayerName,
			Nick, Text, NM);
	}
}

void PlayerAdminMessage::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() < 3)
	{
		IRC::Send("PRIVMSG %s :Usage: !pamsg <name> <message>.\n", Channel);
		return;
	}
	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		GameObject* Target = Functions::Get_Part_Name_Fixed(Msg[2]);
		int TargetID = Get_Player_ID(Target);		
		StringClass Text;

		for (int i = 3; i < Msg.Size()+1; i++)
		{
			Text += Msg[i];	
			if (i != Msg.Size())
			{
				Text += " ";
			}
		}
		Functions::Console("pamsg %d (%s@IRC): %s", TargetID, Nick, Text);
		IRC::SendC(CHAN_PUBLIC, "%s[PAMSG'd %S] (%s@IRC): %s%s", LGREEN, Find_Player(TargetID)->PlayerName,
			Nick, Text, NM);
	}
}

void Bandwidth::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg.Size() < 3)
	{
		IRC::Send("PRIVMSG %s :Usage: !bw <name> <amount> - !bw <name>.\n", Channel);
		return;
	}

	int Count = Functions::Get_Part_Names_Fixed(Msg[2]);

	if (Count < 1)
	{
		IRC::Send("PRIVMSG %s :Player not found.\n", Channel);
	}
	else if (Count > 1)
	{
		IRC::Send("PRIVMSG %s :Multiple players found.\n", Channel);
	}
	else
	{
		GameObject* Target = Functions::Get_Part_Name_Fixed(Msg[2]);
		int TargetID = Get_Player_ID(Target);	

		if (Msg.Size() == 2)
		{
			IRC::SendC(Channel, "%S's bandwidth is currently set to: %d. Ping is: %d. KBPS is: %d\n", 
				Find_Player(TargetID)->PlayerName, Get_Bandwidth(TargetID), Get_Ping(TargetID), Get_Kbits(TargetID));
		}
		else if (Msg.Size() > 2)
		{
			if (!Functions::Is_Number(Msg[3]))
			{
				IRC::SendC(Channel, "Invalid number entered.\n");
				return;
			}
			else
			{
				Functions::Console("setbw %d %s", TargetID, Msg[3]);
				IRC::SendC(Channel, "%S's bandwidth has been set to %s.\n", Find_Player(TargetID)->PlayerName, Msg[3]);
			}
		}
	}
}

void ModeratorList::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	DLOG;
	StringClass Text = "Moderators:";
	bool Found = 0;

	for (HashTemplateIterator<StringClass, Moderator_t*> iter(Settings::ModsGameNick); iter; ++iter)
	{
		Moderator_t* m = iter.getValue();
		Found = 1;

		if (Text.Get_Length() > 80)
		{
			IRC::Send("PRIVMSG %s :%s\n", Channel, Text);
			Text = "";
		}
		Text += StringClass::getFormattedString(" %c%s %s\t\t", m->Access, m->IRCNick, m->InGameNick);
	}

	if (Found)
	{
		IRC::Send("PRIVMSG %s :%s\n", Channel, Text);
	}
	else
	{
		IRC::Send("PRIVMSG %s :List is empty!.\n", Channel);
	}
}

void LogSearch::Activate_IRC(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	DLOG;

	if (Msg.Size() != 2)
	{
		IRC::Send("PRIVMSG %s :Usage: !logsearch <string>\n", Channel);
		return;
	}

	DynamicVectorClass<DB::Row*> Results;
	DB::Query(&Results, "SELECT * FROM `Log` WHERE `Action` LIKE '%%%q%%' ORDER BY time DESC LIMIT 10;", Msg[2]);

	if(Results.Count() == 0)
	{
		IRC::Send("PRIVMSG %s :No results found.\n", Channel);
		DB::Delete_Result(&Results);
		return;
	}
	else
	{
		for(int i = 0; i < Results.Count(); i++)
		{
			DB::Row *r = Results.operator[](i);

			StringClass Time = DB::Get_Column_Data("time", r->Columns);
			StringClass Action = DB::Get_Column_Data("Action", r->Columns);
			StringClass Type = DB::Get_Column_Data("Type", r->Columns);

			time_t t = (time_t)atol(Time);

			char buf[64];
			Functions::Format_Time(t, "%d/%m/%Y %H:%M:%S", buf, 64);

			IRC::Send("NOTICE %s :[%s][%s] %s\n", Nick, buf, Type, Action);
		}
		DB::Delete_Result(&Results);
	}
}